﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;



namespace bajaWare.UserControl.Grantia
{

    public partial class wucGarantiaCredito : System.Web.UI.UserControl
    {
        public int? iGarantiasId{get;set;}
        public int? iOperacionId{get;set;}
        public Int16? iIndividual {

            get
            {
                return (Int16?)ViewState["iIndividual"];
            }
            set
            {
                ViewState["iIndividual"] = value;
            }

                    
                     
        
        }
       
        public InterfacesServicesCatalogos.IinterfacesServicesCatalogos rsCatalogos = new InterfacesServicesCatalogos.IinterfacesServicesCatalogosClient();
        public InterfaceServiceGarantias.IinterfacesServiceGarantia rsGarantias = new InterfaceServiceGarantias.IinterfacesServiceGarantiaClient();
        protected void Page_Load(object sender, EventArgs e)
        {
            if(!IsPostBack)
            {
                if (Convert.ToString(Session["negocio"]) == "I")
                    iIndividual = 1;
                else
                    iIndividual = 0;
                CargaDrownDopList();
            }
        }
        private void CargaDrownDopList()
        {
            ddlTipoGarantia.DataSource = rsCatalogos.ListadoTipoGarantia(Convert.ToInt32(iIndividual));
            ddlTipoGarantia.DataValueField = "intInterfaceid";
            ddlTipoGarantia.DataTextField = "vchInterface";
            ddlTipoGarantia.DataBind();

            ddlMoneda.DataSource = rsCatalogos.ListadoMoneda();
            ddlMoneda.DataValueField = "intInterfaceid";
            ddlMoneda.DataTextField = "vchInterface";
            ddlMoneda.DataBind();

            ddlBancoGarantia.DataSource = rsCatalogos.ListadoInstitucion();
            ddlBancoGarantia.DataValueField = "intInterfaceid";
            ddlBancoGarantia.DataTextField = "vchInterface";
            ddlBancoGarantia.DataBind();
        }
        public void llenaInformacion(InterfaceServiceGarantias.Garantia garantia)
        {
            

           // if (rsGarantias.ObtieneGarantias(iOperacionId).Count() > 0)
              //  garantia = rsGarantias.ObtieneGarantias(iOperacionId).First();
            //else
            //    garantia = new InterfaceServiceGarantias.Garantia();
            if (garantia.iGarantiaId != 0)
            {
                txtDescripcion.Text = garantia.vchDescripcion;
                txtFechaValuacion.Text = garantia.datFechaValuacion.ToShortDateString();
                txtGradoPrelacion.Text = garantia.sintGradoPrelacion.ToString();
                txtValorGrantia.Text = Convert.ToDecimal(garantia.nValorComercial).ToString().Split('.')[0];
                try
                {
                    ddlTipoGarantia.SelectedValue = garantia.sintTipoGarantiaID.ToString();
                }
                catch
                {
                    ddlTipoGarantia.SelectedIndex = 0;
                }
                ddlMoneda.SelectedValue = garantia.sintMonedaID.ToString();
                ddlBancoGarantia.SelectedValue = garantia.sintInstitucionID.ToString();
                chkBursatilidad.Checked = garantia.bitBursatilidad;
                chkLiquidez.Checked = garantia.bitLiquidez;
                iGarantiasId = garantia.iGarantiaId;
            }
        }
        public bool InsertaInformacion(InterfaceServiceGarantias.Garantia garantia)
        {
             
            
            garantia.iOperacionId = iOperacionId;
            garantia.sintTipoGarantiaID = Convert.ToInt16(ddlTipoGarantia.SelectedValue);
            garantia.nValorComercial = Convert.ToDecimal(txtValorGrantia.Text);
            garantia.sintMonedaID = Convert.ToInt16(ddlMoneda.SelectedValue);
            garantia.datFechaValuacion = Convert.ToDateTime(txtFechaValuacion.Text);
            garantia.sintGradoPrelacion = Convert.ToInt16(txtGradoPrelacion.Text);
            garantia.sintInstitucionID = Convert.ToInt16(ddlBancoGarantia.SelectedValue);
            garantia.vchDescripcion = txtDescripcion.Text;
            garantia.bitBursatilidad = chkBursatilidad.Checked;
            garantia.bitLiquidez = chkLiquidez.Checked;
            garantia.UAlta = Convert.ToInt32(Session["UserId"]); ;
            garantia.sintIndividual = iIndividual;

            InterfaceServiceGarantias.ServiceResult result = rsGarantias.InsertaActualizaGarantia(garantia);
            iGarantiasId = Convert.ToInt32(result.ResultValue);

           return true;
        }
        public void LimpiaDatos()
        {
            txtDescripcion.Text = string.Empty;
            txtFechaValuacion.Text = string.Empty;
            txtGradoPrelacion.Text = string.Empty;
            txtValorGrantia.Text = string.Empty;
            ddlTipoGarantia.SelectedIndex = 0;
            ddlMoneda.SelectedIndex = 0;
            ddlBancoGarantia.SelectedIndex = 0;
            chkBursatilidad.Checked = false;
            chkLiquidez.Checked = false;
            iGarantiasId = 0;
        }
    }
}