﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;

namespace bajaWare.UserControl.OperacionParticipe
{
    public partial class wucParticipe : System.Web.UI.UserControl
    {
        public InterfacesServicePersonas.IinterfacesServicePersonas rsPersonas = new InterfacesServicePersonas.IinterfacesServicePersonasClient();
        public int TipoParticipe
        {
            get
            {
                return ViewState["TipoParticipe"]==null?0:(int)ViewState["TipoParticipe"];
            }
            set
            {
                ViewState["TipoParticipe"] = value;
            }
        }
        public int IdOperacion { get; set; }


        public List<InterfacesServicePersonas.Participe> ListaParticipes
        {
            get
            {
                return ViewState["ListaParticipes"] == null ? (new List<InterfacesServicePersonas.Participe>()) : (List<InterfacesServicePersonas.Participe>)ViewState["ListaParticipes"];
            }
            set
            {
                ViewState["ListaParticipes"] = value;
            }
        }
        protected void Page_Load(object sender, EventArgs e)
        {
            if (!IsPostBack)
            {
             
            }
            wucPersonasParticipes1.btnCierra += new BotonCerrar(wucPersonasParticipes1_btnCierra);
            wucPersonasParticipes1.intOperacionID = Convert.ToInt32(Request.QueryString["intCredito"].ToString());
            wucPersonasParticipes1.intTipoParticipeId = TipoParticipe;
            wucPersonasParticipes1.btnInserta += new BotonInserta(wucPersonasParticipes1_btnInserta);
            wucPersonasParticipes1.btnBusca += new BotonBuscar(wucPersonasParticipes1_btnBusca);
            wucPersonasParticipes1.ddlCambia+=new CambiaTipoDDl(wucPersonasParticipes1_ddlCambia);
            if (TipoParticipe == 4)
            {
                grvParticipe.ShowFooter = true;
                grvParticipe.Columns[4].Visible = true;
                lblAgregaParticipe.Text = "Agrega Accionista";

            }
            if (TipoParticipe == 2)
            {

                grvParticipe.ShowFooter = false;
                grvParticipe.Columns[4].Visible = false;
                lblAgregaParticipe.Text = "Agrega Aval";
            }
        }

void  wucPersonasParticipes1_ddlCambia()
{
    mpeAgrega.Show();
}

        void wucPersonasParticipes1_btnBusca()
        {
            mpeAgrega.Show();
        }

        void wucPersonasParticipes1_btnInserta(bool exito,int Consec)
        {
            if (exito)
            {
                CargarDatos();
               
                mpeAgrega.Hide();

                hdnValores.Value = Consec.ToString();

                  if (TipoParticipe == 4)
            {

                wucAccionista1.ListaParticipes = ListaParticipes;
                wucAccionista1.LlenaFormula(Convert.ToInt32(Request.QueryString["intCredito"].ToString()), Consec);
                mpeAccionista.Show();
                UPD_Datosaccionista.Update();
            }
            else if(TipoParticipe==2)
            {
                wucAvalCredito1.LLenaDatos(Consec);
                mdlDatosDomicilio.Show();
                UPD_DatosDomicilio.Update();
            }
                 
            }
            else
            {
               
                mpeAgrega.Show();
               
            }
        }

        void wucPersonasParticipes1_btnInserta()
        {
           
            mpeAgrega.Hide();
            
        }

        void wucPersonasParticipes1_btnCierra()
        {
            //mpeAgrega.Show();
            mpeAgrega.Hide();
        }

        public void CargarDatos()
        {
            InterfacesServicePersonas.Participe participe= new InterfacesServicePersonas.Participe();
            participe.iParticipeTipoId = TipoParticipe;
            participe.iOperacionId = Convert.ToInt32(Request.QueryString["intCredito"].ToString());
            
            ListaParticipes=  rsPersonas.ListaParticipe(participe).ToList();
            wucPersonasParticipes1.ListaParticipes = ListaParticipes;
            grvParticipe.DataSource = ListaParticipes;
            grvParticipe.DataBind();
        }

        protected void grvParticipe_RowDataBound(object sender, GridViewRowEventArgs e)
        {
            if (TipoParticipe == 4)
            {
                if (e.Row.RowType == DataControlRowType.Footer)
                {
                    e.Row.Cells[3].Text = "Total:";
                    e.Row.Cells[4].Text = ListaParticipes.Sum(s => s.pParticipacion).ToString();
                    e.Row.Cells[4].HorizontalAlign = HorizontalAlign.Center;
                    e.Row.Cells[3].HorizontalAlign = HorizontalAlign.Right;
                    e.Row.Cells[3].Font.Bold= true;
                    e.Row.Cells[4].Font.Bold = true;
                    e.Row.Font.Bold = true;

                }
            }

        }

        protected void grvParticipe_OnRowCommand(object sender, GridViewCommandEventArgs e)
        {
          
        }

        protected void btnDomicilio_Click(object sender, EventArgs e)
        {
            
           
        }

        protected void btnGo_Click(object sender, ImageClickEventArgs e)
        {
            hdnValores.Value =  ((System.Web.UI.WebControls.ImageButton)(sender)).CommandArgument;
            if (TipoParticipe == 4)
            {

                wucAccionista1.ListaParticipes = ListaParticipes;
                wucAccionista1.LlenaFormula(Convert.ToInt32(Request.QueryString["intCredito"].ToString()), Convert.ToInt32(((System.Web.UI.WebControls.ImageButton)(sender)).CommandArgument));
                mpeAccionista.Show();
                UPD_Datosaccionista.Update();
            }
            else if(TipoParticipe==2)
            {
                wucAvalCredito1.LLenaDatos(Convert.ToInt32(((System.Web.UI.WebControls.ImageButton)(sender)).CommandArgument));
                mdlDatosDomicilio.Show();
                UPD_DatosDomicilio.Update();
            }
        }

        protected void BtnAceptarAccionista_Click(object sender, EventArgs e)
        {
            //int row = Convert.ToInt32(hdnValores.Value.Split('|')[0]) - 2;
            InterfaceServicesAccionistas.Accionista accionista= new InterfaceServicesAccionistas.Accionista();
            accionista.Consec = Convert.ToInt32(hdnValores.Value);
            accionista.iPersonaId = ListaParticipes.Find(s=>s.Consec==accionista.Consec).iParticipeId;
            accionista.iOperacionId = Convert.ToInt32(Request.QueryString["intCredito"].ToString());
            accionista.UAlta = Convert.ToInt32(Session["UserId"]);
            bool respuesta=wucAccionista1.InsertaActualiza(accionista);
            //UPD_pnlGdAccionista.Update();
            if (respuesta)
            {
                InterfacesServicePersonas.Participe participe = new InterfacesServicePersonas.Participe();
                participe.iParticipeTipoId = TipoParticipe;
                participe.iOperacionId = Convert.ToInt32(Request.QueryString["intCredito"].ToString());
                grvParticipe.DataSource = rsPersonas.ListaParticipe(participe);
                grvParticipe.DataBind();
                mpeAccionista.Hide();
                ScriptManager.RegisterStartupScript(UPD_Particip, UPD_Particip.GetType(), "Actualiza", "Actualiza();", true);
            }
            else
            {
                mpeAccionista.Show();
            }
        }



        protected void btnGuardaAval_Click(object sender, EventArgs e)
        {
            //int row = Convert.ToInt32(hdnValores.Value.Split('|')[0]) - 2;
            InterfaceServicesAvales.Aval aval = new InterfaceServicesAvales.Aval();
            aval.Consec = Convert.ToInt32(hdnValores.Value);
            aval.iParticipeId = ListaParticipes.Find(s => s.Consec == aval.Consec).iParticipeId;
            aval.iOperacionId = Convert.ToInt32(Request.QueryString["intCredito"].ToString());
            aval.uAlta = Convert.ToInt32(Session["UserId"]);
            bool bolDomicilio;
            if (wucAvalCredito1.InsertaActualiza(aval, out bolDomicilio))
            {
                InterfacesServicePersonas.Participe participe = new InterfacesServicePersonas.Participe();
                participe.iParticipeTipoId = TipoParticipe;
                participe.iOperacionId = Convert.ToInt32(Request.QueryString["intCredito"].ToString());
                grvParticipe.DataSource = rsPersonas.ListaParticipe(participe);
                grvParticipe.DataBind();
                mdlDatosDomicilio.Hide();
               // ScriptManager.RegisterStartupScript(UPD_Particip, UPD_Particip.GetType(), "Actualiza", "Actualiza();", true);
            }
            else
            {
                if(bolDomicilio)
                    ScriptManager.RegisterStartupScript(UPD_Particip, UPD_Particip.GetType(), "Err", "alert('Debe Agregar un Domicilio Fiscal');", true);
                else
                    ScriptManager.RegisterStartupScript(UPD_Particip, UPD_Particip.GetType(), "Err", "alert('Ocurrio un error y no se insertaron los datos');", true);
                mdlDatosDomicilio.Show();
            }
        }


        protected void btnActualiza_Click(object sender, EventArgs e)
        {

        }

        protected void btnAgrega_Click(object sender, EventArgs e)
        {
            bool BolValida = true;
            if (TipoParticipe == 4)
            {
                if (ListaParticipes.Sum(s => s.pParticipacion) >=100)
                    BolValida = false;
            }
            if (BolValida)
                mpeAgrega.Show();
            else
                ScriptManager.RegisterStartupScript(UPD_Agrega, UPD_Agrega.GetType(), "PorExcedido", "alert('No se puede agregar otro inversionista,porque se excederia el porcentaje')", true);

        }


        protected void btnCierraAccionista_Click1(object sender, EventArgs e)
        {
            if(TipoParticipe.ToString()!=string.Empty)
                mpeAccionista.Hide(); 
        }

        protected void grvParticipe_PageIndexChanging(object sender, GridViewPageEventArgs e)
        {

            grvParticipe.PageIndex = e.NewPageIndex;
                grvParticipe.DataSource = ListaParticipes;
                grvParticipe.DataBind();
            
        }
    }
}