﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;

namespace bajaWare.UserControl.OperacionParticipe
{
    public delegate void BotonCerrar();
    public delegate void BotonBuscar();
    public delegate void BotonInserta(bool exito,int Consec);
    public delegate void CambiaTipoDDl();
    public partial class wucPersonasParticipes : System.Web.UI.UserControl
    {
        public event BotonCerrar btnCierra;
        public event BotonInserta btnInserta;
        public event BotonBuscar btnBusca;
        public event CambiaTipoDDl ddlCambia;
        public InterfacesServicesCatalogos.IinterfacesServicesCatalogos rsCatalogos = new InterfacesServicesCatalogos.IinterfacesServicesCatalogosClient();
        private int intPersonaID
        {
            get
            {
                if (ViewState["intPersonaID"] == null)
                    return 0;
                else
                    return (int)ViewState["intPersonaID"];
            }
            set { ViewState.Add("intPersonaID", value); }
        }
        public int intOperacionID
        {
            get
            {
                if (ViewState["intOperacionID"] == null)
                    return 0;
                else
                    return (int)ViewState["intOperacionID"];
            }
            set { ViewState.Add("intOperacionID", value); }
        }
        public int intTipoParticipeId
        {
            get
            {
                if (ViewState["intTipoParticipeId"] == null)
                    return 0;
                else
                    return (int)ViewState["intTipoParticipeId"];
            }
            set { ViewState.Add("intTipoParticipeId", value); }
        }
        public List<InterfacesServicePersonas.Participe> ListaParticipes
        {
            get
            {
                return ViewState["ListaParticipes"] == null ? (new List<InterfacesServicePersonas.Participe>()) : (List<InterfacesServicePersonas.Participe>)ViewState["ListaParticipes"];
            }
            set
            {
                ViewState["ListaParticipes"] = value;
            }
        }
        public InterfacesServicePersonas.IinterfacesServicePersonas rsDatosPersona = new InterfacesServicePersonas.IinterfacesServicePersonasClient();
        protected void Page_Load(object sender, EventArgs e)
        {

            if (!IsPostBack)
            {
                CargaDatosIniciales();
            }

        }
        public void CargaDatosIniciales()
        {
            ddlFisicaMoral.DataSource = rsCatalogos.ListadoPersonalidadJuridica();
            ddlFisicaMoral.DataTextField = "vchInterface";
            ddlFisicaMoral.DataValueField = "intInterfaceid";

            ddlFisicaMoral.DataBind();

            intPersonaID = 0;
            txtNombre.Text = "";
            txtApPaterno.Text = "";
            txtApMaterno.Text = "";
            txtRFC.Text = "";

           
        }
        protected void ddlFisicaMoral_OnSelectedIndexChanged(object sender, EventArgs e)
        {
            MuestraOculta();
        }
        void MuestraOculta()
        {
            if (ddlFisicaMoral.SelectedValue == "2")
            {
                tdApMaterno.Visible = false;
                tdApMaternoText.Visible = false;
                tdApPaterno.Visible = false;
                tdApPaternoText.Visible = false;
                rev_txtRFC.ValidationExpression = @"^(([A-Z]|[a-z]|\s){1})(([A-Z]|[a-z]){2})([0-9]{6})((([A-Z]|[a-z]|[0-9]){3}))|^(([A-Z]|[a-z]|\s){1})(([A-Z]|[a-z]){2})([0-9]{6})";
                fte_txtNombre.Enabled = false;
            }
            else
            {
                tdApMaterno.Visible = true;
                tdApMaternoText.Visible = true;
                tdApPaterno.Visible = true;
                tdApPaternoText.Visible = true;
                rev_txtRFC.ValidationExpression = @"^(([A-Z]|[a-z]|\s){1})(([A-Z]|[a-z]){3})([0-9]{6})((([A-Z]|[a-z]|[0-9]){3}))|^(([A-Z]|[a-z]|\s){1})(([A-Z]|[a-z]){3})([0-9]{6})";
                fte_txtNombre.Enabled = true;
            }
            if (ddlCambia != null)
                ddlCambia();
        }
        public void CargaDatos(InterfacesServicePersonas.clsDatosPersona clsPersona)
        {
            try
            {
                CargaDatosIniciales();

                intPersonaID = clsPersona.intPersonaID;
                txtNombre.Text = clsPersona.strNombre;
                txtApPaterno.Text = clsPersona.strApPaterno;
                txtApMaterno.Text = clsPersona.strApMaterno;
                txtRFC.Text = clsPersona.strRFC;
                ddlFisicaMoral.SelectedValue = clsPersona.intPersonalidadJuridica.ToString();
                MuestraOculta();
            }
            catch (Exception ex)
            {
                throw new Exception(ex.Message);
            }
        }

        

        protected void btnAgregar_Click(object sender, EventArgs e)
        {

            if (intPersonaID == 0)
            {
                InterfacesServicePersonas.clsDatosPersona cls = null;
                cls = rsDatosPersona.ExistePersona(txtRFC.Text,string.Empty);
                if (cls != null)
                {
                    if (cls.intPersonaID != 0)
                    {
                        CargaDatos(cls);
                        intPersonaID = cls.intPersonaID;
                        string PrimerNombre = txtNombre.Text.Split(' ')[0];
                        string segundoNombre = string.Empty;
                        for (int i = 1; txtNombre.Text.Split(' ').Length > i; i++)
                        {
                            if (segundoNombre == string.Empty)
                                segundoNombre += txtNombre.Text.Split(' ')[i];
                            else
                                segundoNombre += " " + txtNombre.Text.Split(' ')[i];

                        }
                        if (ddlFisicaMoral.SelectedValue == "2")
                        {
                            PrimerNombre = txtNombre.Text;
                            segundoNombre = string.Empty;

                        }

                        if (ListaParticipes.FindAll(s => s.iParticipeId == intPersonaID).Count == 0)
                        {
                            int consec=rsDatosPersona.InsertaPersonaParticipe(intOperacionID, intPersonaID, PrimerNombre, segundoNombre, ddlFisicaMoral.SelectedValue == "2" ? string.Empty : txtApPaterno.Text, ddlFisicaMoral.SelectedValue == "2" ? string.Empty : txtApMaterno.Text, Convert.ToInt32(ddlFisicaMoral.SelectedValue), txtRFC.Text, intTipoParticipeId, Convert.ToInt32(Session["UserId"]));
                            if (btnInserta != null)
                            {
                                btnInserta(true, consec);
                            }
                            
                        }
                        else
                        {
                            if (btnInserta != null)
                            {
                                btnInserta(false,0);
                            }
                            ScriptManager.RegisterStartupScript(UPD_Persona, typeof(UpdatePanel), "Error", "javascript:alert('La persona ya existe y no se puede agregar.');", true);
                        }

                    }

                }
                else
                {
                    string PrimerNombre = txtNombre.Text.Split(' ')[0];
                    string segundoNombre = string.Empty;
                    for (int i = 1; txtNombre.Text.Split(' ').Length > i; i++)
                    {
                        if (segundoNombre == string.Empty)
                            segundoNombre += txtNombre.Text.Split(' ')[i];
                        else
                            segundoNombre += " " + txtNombre.Text.Split(' ')[i];

                    }
                    if (ddlFisicaMoral.SelectedValue == "2")
                    {
                        PrimerNombre = txtNombre.Text;
                        segundoNombre = string.Empty;

                    }

                    if (ListaParticipes.FindAll(s => s.iParticipeId == intPersonaID).Count == 0)
                    {
                     int consec= rsDatosPersona.InsertaPersonaParticipe(intOperacionID, intPersonaID, PrimerNombre, segundoNombre, ddlFisicaMoral.SelectedValue == "2" ? string.Empty : txtApPaterno.Text, ddlFisicaMoral.SelectedValue == "2" ? string.Empty : txtApMaterno.Text, Convert.ToInt32(ddlFisicaMoral.SelectedValue), txtRFC.Text, intTipoParticipeId, Convert.ToInt32(Session["UserId"]));
                        if (btnInserta != null)
                        {
                            btnInserta(true, consec);
                        }
                    }
                    else
                    {
                        if (btnInserta != null)
                        {
                            btnInserta(false,0);
                        }
                        ScriptManager.RegisterStartupScript(UPD_Persona, typeof(UpdatePanel), "Error", "javascript:alert('La persona ya existe y no se puede agregar.');", true);
                    }
                }
            }
            else
            {
                string PrimerNombre = txtNombre.Text.Split(' ')[0];
                string segundoNombre = string.Empty;
                for (int i = 1; txtNombre.Text.Split(' ').Length > i; i++)
                {
                    if (segundoNombre == string.Empty)
                        segundoNombre += txtNombre.Text.Split(' ')[i];
                    else
                        segundoNombre += " " + txtNombre.Text.Split(' ')[i];

                }
                if (ddlFisicaMoral.SelectedValue == "2")
                {
                    PrimerNombre = txtNombre.Text;
                    segundoNombre = string.Empty;
                   
                }

                if (ListaParticipes.FindAll(s => s.iParticipeId == intPersonaID).Count == 0)
                {
                   int consec= rsDatosPersona.InsertaPersonaParticipe(intOperacionID, intPersonaID, PrimerNombre, segundoNombre,ddlFisicaMoral.SelectedValue == "2"?string.Empty: txtApPaterno.Text,ddlFisicaMoral.SelectedValue == "2"?string.Empty: txtApMaterno.Text, Convert.ToInt32(ddlFisicaMoral.SelectedValue), txtRFC.Text, intTipoParticipeId, Convert.ToInt32(Session["UserId"]));
                    if (btnInserta != null)
                    {
                        btnInserta(true,consec);
                    }
                }
                else
                {
                    if (btnInserta != null)
                    {
                        btnInserta(false,0);
                    }
                    ScriptManager.RegisterStartupScript(UPD_Persona, typeof(UpdatePanel), "Error", "javascript:alert('La persona ya existe y no se puede agregar.');", true);
                }
                
            }


            intPersonaID = 0;
            CargaDatosIniciales();

        
        }

        protected void btnCerrar_Click(object sender, EventArgs e)
        {
            intPersonaID = 0;
            CargaDatosIniciales();
            if (btnCierra != null)
            {
                btnCierra();
            }

        }

        protected void btnBuscar_Click(object sender, EventArgs e)
        {
            try
            {
                InterfacesServicePersonas.clsDatosPersona cls = null;
                intPersonaID = 0;

                cls = rsDatosPersona.ExistePersona(txtRFC.Text, txtNombre.Text + txtApPaterno.Text + txtApMaterno.Text);


                if (cls != null)
                    if (cls.intPersonaID != 0)
                    {
                        ScriptManager.RegisterStartupScript(UPD_Persona, typeof(UpdatePanel), "MsjExiste", "javascript:alert('Existe la Persona');", true);
                        CargaDatos(cls);
                    }


            }
            catch (Exception ex)
            {
                ScriptManager.RegisterStartupScript(UPD_Persona, typeof(UpdatePanel), "Error", "javascript:alert('Error al buscar la persona.');", true);
            }
            if (btnBusca != null)
                btnBusca();
        }

        protected void txtRFC_TextChanged(object sender, EventArgs e)
        {
            //rfv_txtRFC.Enabled = false;
        }



    }
}