﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;
using Seguridad.DataAccessIntegration;
using Seguridad.DataAccessIntegration.Autenticacion;
using Seguridad.Logic.Autenticacion;
using Seguridad.Logic.Autorizacion;
using Seguridad.DataAccessIntegration.Autorizacion;
using Seguridad.Logic.Utilidades;

namespace bajaWare
{
    public partial class frmAutentica : System.Web.UI.Page
    {
        protected void Page_Load(object sender, EventArgs e)
        {
            {
                if (Request.QueryString["data1"] != null)
                {
                    string token = Request.QueryString["data1"].ToString();
                    string usuarioId = Request.QueryString["data2"].ToString();
                    string sistemaId = Request.QueryString["data3"].ToString();
                    string ip = Request.QueryString["data4"].ToString();
                    string negocio = Request.QueryString["data5"].ToString();

                    string CapturaTodos = Request.QueryString["data6"] == null ? System.Configuration.ConfigurationManager.AppSettings.Get("bitCapturaTodo") : Request.QueryString["data6"].ToString();
                    string credito =  Request.QueryString["data7"] == null ? "0" : Request.QueryString["data7"].ToString();
                    string cliente = Request.QueryString["data8"] == null ? "0" : Request.QueryString["data8"].ToString();

                    token = clsEncriptacion.DecryptString(token);
                    usuarioId = clsEncriptacion.DecryptString(usuarioId);
                    sistemaId = clsEncriptacion.DecryptString(sistemaId);
                    ip = clsEncriptacion.DecryptString(ip);
                    
                    Seguridad.DataAccess.Linq.Autenticacion.tbl_BIT_Sesiones sesion = new Seguridad.DataAccess.Linq.Autenticacion.tbl_BIT_Sesiones();
                    sesion.guidToken = Guid.Parse(token.ToUpper());
                    sesion.sintSistemaID = short.Parse(sistemaId);
                    sesion.intUsuarioID = int.Parse(usuarioId);
                    sesion.vchSesionID = Session.SessionID;
                    sesion.bitEstatusSesion = true;
                    sesion.bitEstatusToken = true;

                    clsDatosOperaciones datos = new clsDatosOperaciones(Convert.ToInt32(usuarioId), ip);

                    sesion = new clsManejoSesion().ValidarSesion(sesion.guidToken, sesion.intUsuarioID.Value, sesion.sintSistemaID, ip);
                    if (sesion != null)
                    {
                        DatosUsuario usuario = new clsManejoUsuario().GetDatosUsuario(sesion.intUsuarioID.Value, sesion.sintSistemaID);
                        List<MenuSistema> permisos = new clsManejoPermisos().GetPermisos(usuario.Perfil_Id);

                        Session["PerfilID"] = usuario.Perfil_Id;
                        Session["User"] = usuario.User_Desc;
                        Session["Perfil"] = usuario.SDescripPerfil;
                        Session["UserName"] = usuario.SNameUser;
                        Session["Puesto"] = usuario.StrPuesto;
                        Session["DatosSesion"] = sesion;
                        Session["DatosInformativos"] = datos;
                        Session["sintAreaID"] = usuario.SintAreaID;
                        Session["sintDepartamentoID"] = usuario.SintDepartamentoID;
                        Session["negocio"] = negocio;
                        Session["UserId"] = usuario.UserId;


                        Session["bitCapturaTodo"] = CapturaTodos;
                        Session["sintCreditoID"] = credito;
                        Session["sintClienteID"] = cliente;
                        Session["sintSistemaID"] = System.Configuration.ConfigurationManager.AppSettings.Get("sintSistemaID");

                        Response.Redirect("Interfaces/frmBusqueda.aspx", true);
                    }
                    else
                        this.lblAutenticacion.Text = "Error al Autenticar. Por favor vuelva a intentarlo más tarde o contacte con el Administrador.";
                }
                else
                    // Ejecuta Script
                    this.lblAutenticacion.Text = "Error al Autenticar. Por favor vuelva a intentarlo más tarde o contacte con el Administrador.";
            }
        }
    }

}