﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using Registec.Entities;
using Registec.DataAccess.Context;

namespace Registec.DataAccess
{
    public class RegistroDataAcess
    {
        public List<Registro> Get_registro(Registro mdlRegistro)
        {
            List<Registro> mdlReturn = new List<Registro>();
            try
            {
                using (lnqRegistroDataContext dc = new lnqRegistroDataContext(Helper.ConnectionString()))
                {
                    var query = from item in dc.stp_get_DataRegistros(mdlRegistro.intRegistroId)
                                select new Registro()
                                {
                                    intRegistroId = item.INTREGISTROID,
                                    intNumParticipantes = (int)item.INTNUMPARTICIPANTES,
                                    bitActivo = (bool)item.BITACTIVO,
                                    datFechaAlta = item.DATFECHAALTA.ToString(),
                                    datFechaInicioReg = item.DATFECHAFINREG.ToString(),
                                    intUsuarioIdAlta = (int)item.INTUSUARIOIDALTA
                                };
                    mdlReturn.AddRange(query);

                }
            }
            catch (Exception exx)
            {
                throw exx;
            }

            return mdlReturn;
        }
    }
}
